# -*- coding: utf-8 -*-
"""
Canonical operator exports for Absolute Relativity core.

Exports (first-class):
  F (renewal/outward)
  S (sink/inward)
  T (trade/distinction)
  C (sync)
  𝓑 (boundary projector)

Deprecated shims (warn once):
  X -> T
  Φ(arg) -> C(T(arg))
"""
from __future__ import annotations
import warnings

from .renewal import F
from .sinking import S
from .sync import C
from .boundary import B as 𝓑        # new boundary projector (see boundary.py)
from .trade import T                # new official Trade/Distinction

def X(*args, **kw):
    warnings.warn("X is deprecated; use T", stacklevel=2)
    return T(*args, **kw)

def Φ(arg):
    warnings.warn("Φ is deprecated; use C∘T", stacklevel=2)
    return C(T(arg))
